

/*
 *  RTC header file
 *
 */

#ifndef RTC_
#define RTC_

#include "DM388_types.h"

/* ------------------------------------------------------------------------ *
 *  RTC Definitions                                                         *
 * ------------------------------------------------------------------------ */
/* RTC Registers */

#define RTC_BASE                0x480C0000

#define RTC_SEC                 RTC_BASE + 0x00  // Seconds 
#define RTC_MIN                 RTC_BASE + 0x04  // Minutes 
#define RTC_HOUR                RTC_BASE + 0x08  // Hours 
#define RTC_DAY0                RTC_BASE + 0x0C  // Days  
#define RTC_MONTH               RTC_BASE + 0x10  // Months  
#define RTC_YEARS               RTC_BASE + 0x14  // Years  
#define RTC_CTRL                RTC_BASE + 0x40  // Control
#define RTC_STATUS              RTC_BASE + 0x44  // Stautus

UINT8 RTC_setreg(UINT32 regnum, UINT8 regval);
UINT8 RTC_getreg(UINT32 regnum, UINT8 *regval);

#endif
